Attribute VB_Name = "modMonitor"
Option Explicit
''' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'''  Copyright  2001 Agilent Technologies Inc.  All rights reserved.
'''
''' You have a royalty-free right to use, modify, reproduce and distribute
''' the Sample Application Files (and/or any modified version) in any way
''' you find useful, provided that you agree that Agilent Technologies has no
''' warranty,  obligations or liability for any Sample Application Files.
'''
''' Agilent Technologies provides programming examples for illustration only,
''' This sample program assumes that you are familiar with the programming
''' language being demonstrated and the tools used to create and debug
''' procedures. Agilent Technologies support engineers can help explain the
''' functionality of Agilent Technologies software components and associated
''' commands, but they will not modify these samples to provide added
''' functionality or construct procedures to meet your specific needs.
''' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'

Public Sub GetScanList(io As Agt3494A, lst As ListBox)
    ' get the scan list and fill in the combo box on the toolbar
    Dim strChannelList() As String
    Dim cancel As Boolean
    Dim i As Integer

    On Error Resume Next

    GetScanListArray io, strChannelList, cancel

    If cancel = False Then
        With lst
            .Clear
            .AddItem "Front Panel"
            For i = 0 To UBound(strChannelList)
                lst.AddItem "Channel " & strChannelList(i)
            Next i
            lst.ListIndex = 1
        End With                                           ' monitorCB
    End If
End Sub

Private Sub GetScanListArray(io As Agt3494A, strChannelList() As String, cancel As Boolean)
    ' Returns the scan list as an array of strings
    ' returns cancel as true if there is an error
    Dim strTemp As String
    Dim i As Long

    On Error GoTo getScanListError

    cancel = False

    io.Output "route:scan?"
    ' return the IEEE block as a string
    io.Enter strTemp, "S1"
    
    ' get rid of the first two characters '(@'
    strTemp = Mid$(strTemp, 3, Len(strTemp) - 3)
    strChannelList = Split(strTemp, ",")

    Exit Sub

getScanListError:
    cancel = True
End Sub
Public Function Monitor(io As Agt3494A, txt As TextBox, ByVal channel As String)
    ' calls the instrument and gets the reading for channel or if
    ' channel is not a channel number uses the channel set on front panel
    Dim reading As Double
    Dim cmd As String
    Dim strTemp As String

    cmd = "Route:Monitor (@" & channel & ")"

    With io
        If IsNumeric(channel) Then
            .Output cmd
            strTemp = "ch " & Str$(channel) & ",  "
        Else
            strTemp = "Front Panel, "
        End If
        .Output "Route:Monitor:State ON"
        .Output "Route:Monitor:Data?"
        .Enter reading
        txt.SelText = strTemp & Str$(reading) & vbCrLf
    End With


End Function
